/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.generaltab;

import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.images.VWSIMImageLoader;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWCalendarControlDialog;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWDateTimeFormat;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class VWSIMBeginDateTimePanel
extends JPanel
implements ActionListener,
IVWSIMPropertyChangeListener {
    private JLabel m_dateLabel = null;
    private JTextField m_dateTextField = null;
    private JLabel m_timeLabel = null;
    private JTextField m_timeTextField = null;
    private JButton m_calendarButton = null;
    private GridBagConstraints m_gridCons = null;
    protected VWSIMPropertyData m_propertyData = null;

    public void init(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.m_propertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        this.setLayout(new GridBagLayout());
        this.m_gridCons = new GridBagConstraints();
        this.initDateTimeControls();
    }

    public void releaseReferences() {
        this.m_dateLabel = null;
        this.m_dateTextField = null;
        this.m_calendarButton = null;
        this.m_timeLabel = null;
        this.m_timeTextField = null;
        this.m_gridCons = null;
        this.m_propertyData = null;
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src.equals(this.m_calendarButton)) {
            this.performCalendarButtonAction();
        }
    }

    public void propertyDataChanged(VWSIMPropertyChangeEvent event) {
        switch (event.getID()) {
            case 101: {
                this.performChangeScenarioDefinition();
            }
        }
    }

    protected Date getDate() {
        Object startDate;
        if (this.m_propertyData != null && (startDate = this.m_propertyData.getScenarioDefinition().getStartTime()) != null && startDate instanceof Date) {
            return (Date)startDate;
        }
        return null;
    }

    protected void setDate(Date newDate) throws Exception {
        if (this.m_propertyData != null) {
            this.m_propertyData.getScenarioDefinition().setStartTime(newDate);
            this.m_propertyData.setDirty();
        }
    }

    private void initDateTimeControls() {
        this.m_dateLabel = new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_date));
        this.m_gridCons.gridx = 0;
        this.m_gridCons.gridy = 0;
        this.m_gridCons.fill = 0;
        this.m_gridCons.weightx = 0.0;
        this.m_gridCons.weighty = 0.0;
        this.m_gridCons.anchor = 21;
        this.m_gridCons.gridwidth = 1;
        this.m_gridCons.gridheight = 1;
        this.m_gridCons.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_dateLabel, this.m_gridCons);
        this.m_dateTextField = new JTextField();
        this.m_dateTextField.setEditable(false);
        ++this.m_gridCons.gridx;
        this.m_gridCons.fill = 2;
        this.m_gridCons.weightx = 0.2;
        this.m_gridCons.anchor = 23;
        this.add((Component)this.m_dateTextField, this.m_gridCons);
        this.m_timeLabel = new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_time));
        ++this.m_gridCons.gridx;
        this.m_gridCons.fill = 0;
        this.m_gridCons.weightx = 0.0;
        this.m_gridCons.anchor = 21;
        this.add((Component)this.m_timeLabel, this.m_gridCons);
        this.m_timeTextField = new JTextField();
        this.m_timeTextField.setEditable(false);
        ++this.m_gridCons.gridx;
        this.m_gridCons.fill = 2;
        this.m_gridCons.weightx = 0.2;
        this.m_gridCons.anchor = 23;
        this.add((Component)this.m_timeTextField, this.m_gridCons);
        this.m_calendarButton = VWSIMImageLoader.createIconButton("calendar.gif", VWSIMResource.s_calendar);
        this.m_calendarButton.addActionListener(this);
        ++this.m_gridCons.gridx;
        this.m_gridCons.fill = 0;
        this.m_gridCons.weightx = 0.6;
        this.add((Component)this.m_calendarButton, this.m_gridCons);
        this.performChangeScenarioDefinition();
    }

    private void performCalendarButtonAction() {
        try {
            String initDateString = this.m_dateTextField.getText();
            String initTimeString = this.m_timeTextField.getText();
            VWCalendarControlDialog calendarDlg = new VWCalendarControlDialog(this.m_propertyData.getParentFrame(), 102, initDateString + " " + initTimeString);
            calendarDlg.setVisible(true);
            int status = calendarDlg.getCloseStatus();
            if (status == 1) {
                Date date = calendarDlg.getDate();
                String dateString = VWDateTimeFormat.getDateString(date);
                String timeString = VWDateTimeFormat.getTimeString(date);
                this.m_dateTextField.setText(dateString);
                this.m_timeTextField.setText(timeString);
                this.setDate(date);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performChangeScenarioDefinition() {
        try {
            Date date = this.getDate();
            if (date != null) {
                this.m_dateTextField.setText(VWDateTimeFormat.getDateString(date));
                this.m_timeTextField.setText(VWDateTimeFormat.getTimeString(date));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

